# Quick Start Guide - Paul Agonda PR Portfolio

Get your PR portfolio website up and running in 3 steps.

## Step 1: Setup WordPress (30 minutes)

### If you don't have WordPress yet:
1. Choose a hosting provider (WordPress.com, Kinsta, Bluehost, etc.)
2. Create a WordPress instance
3. Follow the detailed setup in [WORDPRESS_SETUP.md](./WORDPRESS_SETUP.md)

### Quick WordPress Setup:
1. Install plugins:
   - Advanced Custom Fields (ACF)
   - Custom Post Type UI
   - WP CORS (for CORS headers)

2. Create custom post types:
   - `portfolio_item` - For case studies
   - `press_release` - For press releases

3. Create ACF field groups:
   - Portfolio: client_name, challenge, results
   - Press Release: publication_name, publication_date, pdf_link

4. Create sample content (at least 1 portfolio item and 1 blog post)

5. Enable REST API: Settings → Permalinks → Save

6. Test API: Visit `https://your-wordpress.com/wp-json/wp/v2/posts`

## Step 2: Deploy to Vercel (10 minutes)

### Via Vercel Dashboard (Easiest):
1. Go to https://vercel.com/new
2. Connect your GitHub account
3. Select this repository
4. Add environment variable:
   - `NEXT_PUBLIC_WORDPRESS_URL` = `https://your-wordpress-site.com`
5. Click "Deploy"

### Via Vercel CLI:
```bash
# Install Vercel CLI
npm i -g vercel

# Deploy
vercel

# Add environment variable when prompted
```

## Step 3: Update Content (Ongoing)

### Add Portfolio Items:
1. WordPress Admin → Portfolio Items → Add New
2. Title: Case study name
3. Content: Full description
4. Featured Image: Project screenshot
5. Custom fields: Client name, challenge, results
6. Publish

### Add Blog Posts:
1. WordPress Admin → Posts → Add New
2. Title: Article title
3. Content: Article text
4. Featured Image: Header image
5. Publish

**That's it!** Content appears on your site automatically.

## Environment Setup

### Create `.env.local`:
```env
NEXT_PUBLIC_WORDPRESS_URL=https://your-wordpress-site.com
```

### Local Development:
```bash
npm install
npm run dev
```

Visit `http://localhost:3000`

## Your Site Structure

```
Homepage (/)
├── About (/about)
├── Portfolio (/portfolio)
│   └── Portfolio Item (/portfolio/case-study-slug)
├── Articles (/articles)
│   └── Article (/articles/article-slug)
├── Press Releases (/press-releases)
└── Contact (/contact)
```

## Key Features

✓ **Professional Design** - Navy/Gold executive aesthetic
✓ **Headless WordPress** - Manage content in WordPress, display on Next.js
✓ **Fully Responsive** - Mobile, tablet, desktop optimized
✓ **SEO Optimized** - Meta tags, structured data, sitemap
✓ **Fast Performance** - ISR caching, image optimization
✓ **Contact Form** - Built-in contact page with form

## Customization

### Change Colors:
Edit `/app/globals.css` - Update CSS variables like `--primary`, `--accent`

### Change Fonts:
Edit `/app/layout.tsx` - Modify font imports from Google Fonts

### Change Copy/Text:
Edit relevant page files in `/app` - All hardcoded text is here

### Change WordPress URL:
Edit `.env.local` - `NEXT_PUBLIC_WORDPRESS_URL`

## Next Steps

1. ✓ Set up WordPress
2. ✓ Deploy to Vercel
3. Add your content to WordPress
4. Connect custom domain (optional)
5. Update client information (name, phone, email)
6. Share with your client!

## Troubleshooting

### Content not showing?
- Check WordPress URL is correct in `.env.local`
- Verify WordPress REST API is working
- Check browser console for errors

### Deploy fails?
- Clear Vercel cache: Project Settings → Storage → Clear All
- Ensure environment variable is set
- Check build logs for specific error

### Images not loading?
- Make sure featured images are set in WordPress
- Check image URLs are publicly accessible
- Look for CORS errors in browser console

## Support Documents

- [WORDPRESS_SETUP.md](./WORDPRESS_SETUP.md) - Detailed WordPress configuration
- [DEPLOYMENT_GUIDE.md](./DEPLOYMENT_GUIDE.md) - Advanced deployment options
- [README.md](./README.md) - Full project documentation

## Contact Information (Update These)

In `/components/footer.tsx` and `/components/contact-form.tsx`:
- Email: paul@kenyamediarelations.com
- Phone: +254 (0) 700 000 000
- Location: Nairobi, Kenya
- LinkedIn: linkedin.com/in/paulagonda

## Client Information (Update These)

In `/app/page.tsx` and other pages:
- Name: Paul Agonda
- Title: Public Relations Officer
- Company: Kenya Media Relations Company
- Bio/Descriptions

## Performance Tips

1. **Add images** - Use featured images for better visual appeal
2. **Keep content fresh** - Regularly add articles and portfolio items
3. **Optimize images** - Use WebP format in WordPress for smaller file sizes
4. **Cache busting** - Redeploy site to refresh cached content

## You're All Set! 🎉

Your professional PR portfolio is now live. Start adding content to WordPress and watch it appear on your site instantly.

Happy PR-ing!
